<?php
   /*
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $datiGeecomCMS = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    if($datiGeecomCMS["installato"]=="si") {
        $tipiRedirectLogin = ["Home page di Geecom Admin","Home page di Geecom CMS","Link esterno"];
    }
    else {
        $tipiRedirectLogin = ["Home page di Geecom Admin","Link esterno"];
    }
?>

<form name="formAggiornamentoImpostazioniGenerali" action="../controller/controllerImpostazioni.php" method="post">
    <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniGenerali">
    <h4 class="mb-4 title">Impostazioni generali</h4>

        <div class="row mt-5">
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="titolo-del-sito">Titolo piattaforma</label>
                    <input type="text" class="form-control" id="titolo-del-sito" name="nomePiattaforma" value="<?php echo $impostazioni["nomePiattaforma"] ?>" placeholder="Il nome del tuo sito">
                </div>
            </div>

            <div class="col-xl-6">
                <div class="form-group">
                    <label for="titolo-del-sito">URL piattaforma</label>
                    <input type="text" class="form-control" id="titolo-del-sito" name="urlPiattaforma" value="<?php echo $impostazioni["urlPiattaforma"] ?>" placeholder="Un nuovo sito fatto con Geecom!">
                </div>
            </div>
            
            <div class="col-12">
                <div class="form-group">
                    <label for="descrizione">Meta descrizione</label>
                    <input type="text" class="form-control" id="descrizione" name="descrizioneSito" value="<?php echo $impostazioni["descrizioneSito"] ?>" placeholder="Un nuovo sito fatto con Geecom!">
                    <small class="text-muted">Verrà mostrata nella campo "metaDescription" home page della piattaforma</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Disattiva accesso utenti</label>
                    <input type="checkbox" name=disattivaAccessoUtenti class="js-switch" value="si" <?php echo(($impostazioni["disattivaAccessoUtenti"]=="si") ? "checked" : "")?> />
                    <small class="d-block text-muted">Gli utenti non potranno accedere alla piattaforma</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="descrizione">Messaggio accesso disattivato</label>
                    <input type="text" class="form-control" id="messaggioAccessoDisattivato" name="messaggioAccessoDisattivato" value="<?php echo $impostazioni["messaggioAccessoDisattivato"] ?>">
                    <small class="text-muted">Questo messaggio comparirà al posto della form di login quando l'accesso è disattivato</small>
                </div>
            </div>
        </div>
    
        <div class="row mt-5">
            <div class="col-12">
                <h5>Impostazioni utenti</h5>
                <hr>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="metadescription">Pagina login</label>
                    <select name=paginaLogin class="form-control">
                        <?php
                            $queryComponentiDaMostrare = "SELECT * FROM geecAd_contenuti";
                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                            while($pagina = $risComponenti->fetch_assoc()) {
                                $selezionato = "";
                                if($impostazioni["paginaLogin"]==$pagina["id"]) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">Questa pagina viene visualizzata quando l'utente arriva nella root, oppure quando l'utente clicca su "Esci"</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="metadescription">Home page</label>
                    <select name=homePage class="form-control">
                        <?php
                            $queryComponentiDaMostrare = "SELECT * FROM geecAd_contenuti";
                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                            while($pagina = $risComponenti->fetch_assoc()) {
                                $selezionato = "";
                                if($impostazioni["homePage"]==$pagina["id"]) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">Pagina in cui viene rediretto l'utente dopo aver effettuato il login</small>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="form-group">
                    <label for="metadescription">Reindirizzamento dopo il login</label>
                    <select id="tipoRedirectLogin" name="tipoRedirectLogin" class="form-control" onchange="mostraDivPersonalizzatoLogin()">
                        <?php
                            foreach($tipiRedirectLogin as $tipoRedirectLogin) {
                                $selezionato = "";
                                if($impostazioni["tipoRedirectLogin"]==$tipoRedirectLogin) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"$tipoRedirectLogin\" $selezionato >$tipoRedirectLogin</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">Seleziona il Tipo di reindirizzamento una volta che l'utente ha effettuato il login</small>
                </div>
            </div>
            
            <div class="<?= ($impostazioni["tipoRedirectLogin"]=="Link esterno") ? "col-xl-6" : "d-none" ?>" id="divLinkPersonalizzatoLogin">
                <div class="form-group">
                    <label for="descrizione">Link personalizzato</label>
                    <input type="text" class="form-control" id="linkPersonalizzatoLogin" name="linkPersonalizzatoLogin" value="<?php echo $impostazioni["linkPersonalizzatoLogin"] ?>">
                    <small class="text-muted">Link a cui viene rediretto l'utente se hai selezionato "Link esterno" nel form precedente</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="metadescription">Pagina recupero password</label>
                    <select name="paginaRecuperoPassword" class="form-control">
                        <?php
                            $queryComponentiDaMostrare = "SELECT * FROM geecAd_contenuti";
                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                            while($pagina = $risComponenti->fetch_assoc()) {
                                $selezionato = "";
                                if($impostazioni["paginaRecuperoPassword"]==$pagina["id"]) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">Pagina in cui viene rediretto l'utente dopo aver effettuato il login</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Mostra profilo utente </label>
                    <input type="checkbox" name=mostraProfilo class="js-switch" value="si" <?php echo(($impostazioni["mostraProfilo"]=="si") ? "checked" : "")?> />
                    <small class="d-block text-muted">Se attivato nel menu a tendina l'utente avrà un link profilo</small>
                </div>
            </div>
            
            <div class="col-xl-6">
                <div class="form-group">
                    <label for="descrizione">Pagina profilo</label>
                    <select name=paginaProfilo class="form-control">
                        <option value="0" >Seleziona</option>
                        <?php
                            $queryComponentiDaMostrare = "SELECT * FROM geecAd_contenuti WHERE tipo LIKE 'pagina'";
                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                            while($pagina = $risComponenti->fetch_assoc()) {
                                $selezionato = "";
                                if($impostazioni["paginaProfilo"]==$pagina["id"]) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">La pagina a cui gli utenti vengono reindirizzti quando cliccano sul profilo</small>
                </div>
            </div>
            
            <div class="col-12">
                <button class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
            </div>
        </div>
    </form>